/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.scrollable_page;

import java.util.ArrayList;
import me.flashyreese.mods.sodiumextra.client.gui.scrollable_page.AbstractFrame;
import me.flashyreese.mods.sodiumextra.client.gui.scrollable_page.ScrollBarComponent;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class OptionPageScrollFrame
extends AbstractFrame {
    protected final OptionPage page;
    private boolean canScroll;
    private ScrollBarComponent scrollBar = null;

    public OptionPageScrollFrame(Dim2i dim, OptionPage page) {
        super(dim);
        this.page = page;
        this.setupFrame();
        this.buildFrame();
    }

    public void setupFrame() {
        this.children.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group : this.page.getGroups()) {
                y += group.getOptions().size() * 18;
                if (group == lastGroup) continue;
                y += 4;
            }
        }
        boolean bl = this.canScroll = this.dim.height() < y;
        if (this.canScroll) {
            this.scrollBar = new ScrollBarComponent(new Dim2i(this.dim.getLimitX() - 10, this.dim.y(), 10, this.dim.height()), y, this.dim.height(), this::buildFrame, this.dim);
        }
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(this.dim.x(), this.dim.y() + y - (this.canScroll ? this.scrollBar.getOffset() : 0), this.dim.width() - (this.canScroll ? 11 : 0), 18));
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
        if (this.canScroll) {
            this.scrollBar.updateThumbPosition();
        }
        super.buildFrame();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(AbstractWidget::isHovered).findFirst().orElse(this.controlElements.stream().filter(AbstractWidget::isFocused).findFirst().orElse(null));
        this.applyScissor(guiGraphics, this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height(), () -> super.render(guiGraphics, mouseX, mouseY, delta));
        if (this.canScroll) {
            this.scrollBar.render(guiGraphics, mouseX, mouseY, delta);
        }
        if (this.dim.containsCursor((double)mouseX, (double)mouseY) && hoveredElement != null) {
            this.renderOptionTooltip(guiGraphics, hoveredElement);
        }
    }

    private void renderOptionTooltip(GuiGraphics guiGraphics, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 240;
        int boxY = Math.max(dim.y(), this.dim.y());
        int boxX = this.dim.getLimitX() + boxPadding;
        Option option = element.getOption();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>(Minecraft.getInstance().font.split((FormattedText)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(Language.getInstance().getVisualOrder((FormattedText)Component.translatable((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).withStyle(ChatFormatting.GRAY)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.dim.getLimitY() - 25)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.drawRect(guiGraphics, boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            guiGraphics.drawString(Minecraft.getInstance().font, (FormattedCharSequence)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1, false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.dim.containsCursor(mouseX, mouseY) && super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (super.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (this.canScroll) {
            return this.scrollBar.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }
}

